<?php
/*Template Name: Learn More*/
?>
<?php session_start(); ?>
<?php get_header(); ?>
<style type="text/css">
#holdButton {
  display: flex;
  align-items: center;
  padding: 0.8rem 1.2rem;
  border: 2px solid #1d1d1d;
  background: #fff;
  color: #1d1d1d;
  font-size: 1rem;
  cursor: pointer;
  user-select: none;
  position: relative;
  margin-top: 11px;
}
#holdButton:disabled {
  color: #666;
  border-color: #ddd;
  cursor: not-allowed;
}
.crxloader-box {
  width: 40px;
  height: 30px;
  margin-right: 0.9rem;
  position: relative;
}
.border-segment {
  position: absolute;
  background: #1d1d1d;
}
.border-top, .border-bottom { height: 2px; width: 0; }
.border-right, .border-left  { width: 2px; height: 0; }
.border-top   { top: 0; left: 0; }
.border-right { top: 0; right: 0; }
.border-bottom{ bottom: 0; left: 0; }
.border-left  { top: 0; left: 0; }
#tickMark {
  display: none;
  position: absolute;
  inset: 0;
  margin: auto;
  width: max-content;
  font-size: 1.25rem;
  color: green;
  pointer-events: none;
}

/* Feedback & crxloader */
#message1 { margin-top: 0.5rem; font-size: 0.9rem; color: red; }
@keyframes spin { to { transform: rotate(360deg); } }
.loader-overlay {
        position: fixed;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
        background: rgba(0, 0, 0, 0.50);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    .spinner {
        width: 50px;
    height: 50px;
    border: 5px solid rgb(255 255 255);
    border-top: 5px solid #ffffff00;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

nav.navbar.navbar-expand-lg.navbar-light, section.muse-footer{
    display: none;
}
</style>

<section class="popmodel">
<div>
   <div class="pricemodel" role="document">
      <div class="modal-content">
         <div class="modal-body membershipanywhere-modal">
            <div class="modalpanel">
            <p class="popheading">Book a Demo</p>
            <p class="closeicon-musemodal">
                <img src="<?php echo get_template_directory_uri();?>/images/ui-icon-exit_x.svg" class="img-fluid" alt="close" onclick="history.back()">
            </p>
           </div>
            <div class="msaw-main-wrapper">
<div class="msaw-form-wrapper formheading">

<form id="msform" action="https://web.membershipanywhere.com/pricing-mail" method="post" onsubmit="return validateForm()" enctype="multipart/form-data">
   <fieldset>
     <img src="<?php echo get_template_directory_uri();?>/images/ui-icon-back.svg" class="closearrow" onclick="history.back()"/>
      <h3>Great, let’s start with the basics.</h3>
      <p>Let us know how we can get in touch with you. We’ll never rent or sell this information.</p>
      <label class="msaw-form-label"> Your name </label>
      <input type="text" name="fname" class="msaw-form-input" required />
      <span class="error"></span>
      <label class="msaw-form-label"> Your work email address </label>
      <input type="email" name="email" class="msaw-form-input" required />
      <span class="error"></span>
      <input type="text" name="url" value="" style="display:none;">
      <!-- <p class="txtinfo"></p> -->
     <input type="button" name="next" class="next action-button msaw-btn" value="Continue" />
   </fieldset>
   <fieldset>
      <img src="<?php echo get_template_directory_uri();?>/images/ui-icon-back.svg" class="previous" />
      <h3>Tell us a little bit about your organization.</h3>
      <label class="msaw-form-label msawgap"> Your organization’s name </label>
      <input type="text" name="organization" id="inputField" class="msaw-form-input" required />
      <span class="error"></span>
      <label class="msaw-form-label"> Does your organization use a membership system? </label>
      <select name="oms" class="msaw-form-input" required>
        <option value=""></option>
         <option value="Yes" class="omscondition">Yes</option>
         <option value="No">No</option>
         <option value="I am Not Sure">I'm not sure</option>
      </select>
      <span class="error"></span>
      <input type="button" name="next" class="next action-button msaw-btn" value="Continue" />
   </fieldset>
   <fieldset>
      <img src="<?php echo get_template_directory_uri();?>/images/ui-icon-back.svg" class="previous" />
      <h3>Tell us a little more about <span id="display"></span>.</h3>
      <label class="msaw-form-label msawgap "> Number of members </label>
      <input type="text" name="nom" class="msaw-form-input" placeholder="An estimate is fine" maxlength="10" oninput="allowOnlyNumbers(event)" required />
      <span class="error"></span>
      <div class="membershipselect">
  <label class="msaw-form-label">Which membership system do you use?</label>
  <select name="membership" class="msaw-form-input membershippanel" id="membershipSelect" required>
    <option value=""></option>
    <option value="Acme Ticketing">Acme Ticketing</option>
    <option value="Accesso Siriusware">Accesso Siriusware</option>
    <option value="Blackbaud Altru">Blackbaud Altru</option>
    <option value="Bloomerang">Bloomerang</option>
    <option value="DonorDock">DonorDock</option>
    <option value="DonorPerfect">DonorPerfect</option>
    <option value="eTapestry">eTapestry</option>
    <option value="eTix">eTix</option>
    <option value="Gateway Ticketing Systems">Gateway Ticketing Systems</option>
    <option value="Little Green Light">Little Green Light</option>
    <option value="MemberClicks">MemberClicks</option>
    <option value="Neon One">Neon One</option>
    <option value="NonProfit Easy">NonProfit Easy</option>
    <option value="NPSP">NPSP</option>
    <option value="PatronManager">PatronManager</option>
    <option value="Raisers Edge NXT">Raiser’s Edge NXT</option>
    <option value="Raisers Edge">Raiser’s Edge</option>
    <option value="Salesforce">Salesforce</option>
    <option value="Spektrix">Spektrix</option>
    <option value="Tessitura Network">Tessitura Network</option>
    <option value="Versai">Versai</option>
    <option value="Virtuous">Virtuous</option>
    <option value="Not Listed">Not Listed</option>
  </select>
  <span class="error notlisted-error"></span>
  
  <div id="additionalInput" style="display: none;">
    <input type="text" id="otherMembershipInput" class="msaw-form-input" style="margin-top:10px;" placeholder="Please Specify membership system you use" />
    <span class="error"></span>
  </div>
  
  <!-- Hidden field to submit input value when "Not Listed" is selected -->
  <input type="hidden" id="finalMembershipInput" name="membership">

</div>
     <input type="button" name="next" class="next action-button msaw-btn" value="Continue" />
   </fieldset>
   <fieldset class="chepanel">
      <h3>Which products are you interested in?</h3>
      <div class="msawgap">
        <span id="cerror" class="cerror">Please select at least one option.</span>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="Digital membership cards" onclick="updateTextInput()"/><span>Digital membership cards</span>
         </div>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="Membership & visitor loyalty rewards" onclick="updateTextInput()" /><span>Membership & visitor loyalty rewards</span>
         </div>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="Automated renewal reminders" onclick="updateTextInput()" /><span>Automated renewal reminders</span>
         </div>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="SMS texting" onclick="updateTextInput()" /><span>SMS texting</span>
         </div>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="Guest surveys" onclick="updateTextInput()" /><span>Guest surveys</span>
         </div>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="Fast-lane entry" onclick="updateTextInput()" /><span>Fast-lane entry</span>
         </div>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="Native wallet tickets" onclick="updateTextInput()" /><span>Native wallet tickets</span>
         </div>
         <div class="ms-group">
            <input type="checkbox" name="interested[]" value="I’m not sure" onclick="updateTextInput()" /><span>I’m not sure</span>
         </div>
      </div>
      <input type="button" name="next" class="next action-button msaw-btn" value="Continue" />
      <img src="<?php echo get_template_directory_uri();?>/images/ui-icon-back.svg" class="previous" />
      <input type="hidden" name="productsins" id="interestedInput" readonly />
   </fieldset>
    <fieldset>
    <img src="<?php echo get_template_directory_uri();?>/images/ui-icon-back.svg" class="previous" />
    <h3>Help us prepare for your demo.</h3>
    <label class="msaw-form-label msawgap">How did you hear about us?</label>
    <input type="text" name="aboutus" id="aboutUsInput" class="msaw-form-input" required>
    <span class="error"></span>
    <label class="msaw-form-label msawgap">Anything else we should know?</label>
    <input type="text" name="comments" maxlength="500" class="msaw-form-input">
    <span class="error"></span>
    <input id="contactName" type="hidden" readonly required>
    <!--Captcha-->
    <button type="button" id="holdButton" aria-label="Hold to verify">
      <div class="crxloader-box" id="crxloaderBox">
        <div class="border-segment border-top"></div>
        <div class="border-segment border-right"></div>
        <div class="border-segment border-bottom"></div>
        <div class="border-segment border-left"></div>
        <div id="tickMark">&#10003;</div>
      </div>
      <span>Press and Hold</span>
    </button>
    <div id="message1"></div>
    <!--Captcha-->
    <input type="button" name="next" id="pricingsnext" class="next action-button msaw-btn" value="Continue"/>
    <input type="submit" name="submit" id="pricingsubmit" class="msaw-btn" value="Continue" style="display: none;" />
    </fieldset>
    <fieldset>
    <h3>Help us prepare for your demo.</h3>
    <label class="msaw-form-label msawgap">How did you hear about us?</label>
    <input type="text" class="msaw-form-input">
    <label class="msaw-form-label msawgap">Anything else we should know?</label>
    <input type="text" maxlength="500" class="msaw-form-input">
    <input type="button" class="next action-button msaw-btn" value="Continue"/>
    <input type="submit" class="msaw-btn" value="Continue" style="display: none;" />
    <div class="loader-overlay" id="loader" style="display: flex;">
    <div class="spinner"></div>
    </div>
    </fieldset>
</form>
</div>
</div>
         </div>
         <br>
      </div>
   </div>
</div>
</section>
<script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js'></script>
<script>
 $(function () {
  const $holdButton    = $('#holdButton');
  const $message       = $('#message1');
  const $loaderBox     = $('#crxloaderBox');
  const $form          = $('#msform');
  const $submitButton  = $('#submitBtn');
  const $tickMark      = $('#tickMark');
  const $nameField     = $('#contactName');  
  const $bt = $loaderBox.find('.border-top'),
        $br = $loaderBox.find('.border-right'),
        $bb = $loaderBox.find('.border-bottom'),
        $bl = $loaderBox.find('.border-left');
  const HOLD_TIME = 3000;
  const INTERVAL_TIME = 20;
  let interval, elapsed = 0;
  let verified = false;
  function resetLoader() {
    clearInterval(interval);
    elapsed = 0;
    $bt.width(0); $br.height(0); $bb.width(0); $bl.height(0);
    $tickMark.hide();
  }
  function completeVerification() {
    verified = true;
    $tickMark.fadeIn();
    $nameField.val('verified');
    $submitButton.prop('disabled', false);
    $message.text('Verified! You passed the CAPTCHA.').css('color', 'green');
  }

  // Start hold
  function startHold(e) {
    e.preventDefault();
    if ($holdButton.prop('disabled') || verified) return;
    $message.text('Holding…').css('color', '#1d1d1d');
    resetLoader();

    interval = setInterval(() => {
      elapsed += INTERVAL_TIME;
      const pct = elapsed / HOLD_TIME;
      const w = $loaderBox.width(), h = $loaderBox.height();

      if (pct <= 0.25) {
        $bt.width(w * (pct / 0.25));
      } else if (pct <= 0.5) {
        $bt.width(w);
        $br.height(h * ((pct - 0.25) / 0.25));
      } else if (pct <= 0.75) {
        $bt.width(w);
        $br.height(h);
        $bb.width(w * ((pct - 0.5) / 0.25));
      } else {
        $bt.width(w); $br.height(h);
        $bb.width(w);
        $bl.height(h * ((pct - 0.75) / 0.25));
      }

      if (elapsed >= HOLD_TIME) {
        clearInterval(interval);
        completeVerification();
      }
    }, INTERVAL_TIME);
  }
  function cancelHold() {
    if (!verified) {
      clearInterval(interval);
      resetLoader();
      $message.text('Please complete the CAPTCHA.').css('color', 'red');
    }
  }
 function validateForm(e) {
      $form.find('.error').removeClass('error');
      let isValid = true;

      $form.find('[required]').each(function () {
        if (!this.value.trim()) {
          isValid = false;
          $(this).addClass('error');
        }
      });

      if (!isValid) {
        e.preventDefault();
        $message.text('Please complete the CAPTCHA.').css('color', 'red');
      } else {
        $('#crxloader').show();
        $submitButton.hide();
      }
    }
  $submitButton.prop('disabled', false);
  $holdButton.on('mousedown touchstart', startHold);
  $holdButton.on('mouseup mouseleave touchend touchcancel', cancelHold);
  $form.on('submit', validateForm);
});

</script>
<script>
document.getElementById('pricingsubmit').addEventListener('click', function() {
    const aboutUsInput = document.getElementById('aboutUsInput');
    const messageError = document.getElementById('messageError');
    if (aboutUsInput.value.trim() === '') {
        messageError.style.display = 'inline';
    } else {
        messageError.style.display = 'none';
        document.getElementById('loader').style.display = 'flex';
        setTimeout(function() {
            document.getElementById('loader').style.display = 'none';
        }, 3000);
    }
});

  document.getElementById('membershipSelect').addEventListener('change', function () {
    var additionalInput = document.getElementById('additionalInput');
    var otherMembershipInput = document.getElementById('otherMembershipInput');
    var finalMembershipInput = document.getElementById('finalMembershipInput');
    var membershipSelected = document.getElementById('membershipSelect');
    var notlistenError = document.querySelector('.error.notlisted-error');

    if (this.value === 'Not Listed') {
      // Show additional input and clear the select value
      additionalInput.style.display = 'block';
      notlistenError.style.display = 'none';
      this.removeAttribute('required');
      otherMembershipInput.setAttribute('required', 'required');
      this.value = ''; // Clear the select value
      finalMembershipInput.value = ''; // Clear the hidden input
      
      // Listen for changes in the additional input field
      otherMembershipInput.addEventListener('input', function () {
        finalMembershipInput.value = otherMembershipInput.value;
      });
      membershipSelected.value = "Not Listed";
    } else {
      // Hide additional input and clear its value
      additionalInput.style.display = 'none';
      notlistenError.style.display = 'block';
      otherMembershipInput.removeAttribute('required');
      otherMembershipInput.value = ''; // Clear the input field
      document.getElementById('membershipSelect').setAttribute('required', 'required');
      // Update hidden field with the selected value
      finalMembershipInput.value = document.getElementById('membershipSelect').value;
    }
  });
</script>
<script type="text/javascript">
const inputField = document.getElementById('inputField');
const display = document.getElementById('display');
inputField.addEventListener('input', function() {
            display.textContent = inputField.value;
        });



  function updateTextInput() {
        const checkboxes = document.querySelectorAll('input[name="interested[]"]:checked');
        const selectedValues = Array.from(checkboxes).map(cb => cb.value).join(', ');
        document.getElementById('interestedInput').value = selectedValues;
    }

    // Form validation
    function validateForm() {
        // Checkbox validation
        const checkboxes = document.querySelectorAll('input[name="interested[]"]');
        const isChecked = Array.from(checkboxes).some(checkbox => checkbox.checked);
        const errorElement = document.getElementById('cerror');
       

        // Initialize error messages
        let hasError = false;

        // Validate checkboxes
        if (!isChecked) {
            errorElement.textContent = 'Please select at least one checkbox.';
            errorElement.classList.add('cshow');
            hasError = true;
        } else {
            errorElement.classList.remove('cshow');
        }

     

        // Check if textarea is filled
         const messageField = document.querySelector('input[name="aboutus"]');
         const messageError = document.getElementById('messageError');

         if (!messageField.value.trim()) {
            messageError.style.display = 'block'; // Show error message
            hasError = true;
         } else {
             messageError.style.display = 'none'; // Hide error message
         }

    

        return !hasError; // Allow form submission if there are no errors
    }





        function allowOnlyNumbers(event) {
            const input = event.target;
            input.value = input.value.replace(/[^0-9]/g, '');
        }

$(document).ready(function () {
    $('select[name="oms"]').on('change', function () {
        var selectedValue = $(this).val();

        if (selectedValue === 'No' || selectedValue === 'I am Not Sure') {
           $('.membershipselect').hide().find('select').prop('required', false); // Hide and remove required
        } else {
             $('.membershipselect').show().find('select').prop('required', true); // Show and set required
        }
    });
});

 function updateTextInput() {
            const checkboxes = document.querySelectorAll('input[name="interested[]"]:checked');
            const values = Array.from(checkboxes).map(checkbox => checkbox.value);
            document.getElementById('interestedInput').value = values.join(', ');
        }
</script>
<script type="text/javascript">
$(document).ready(function() {
    var current_fs, next_fs; // fieldsets
    var current = 1;
    var steps = $("fieldset").length;
    setProgressBar(current);

    // Validate the current fieldset
    function validateFieldset(fieldset) {
        var isValid = true;
        fieldset.find("input[required], select[required]").each(function() {
            if ($(this).val().trim() === '') {
                isValid = false;
                $(this).next(".error").text("This field is required.");
            } else {
                $(this).next(".error").text(""); // Clear previous error messages
            }
        });

        fieldset.find("input[type='email']").each(function() {
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailPattern.test($(this).val())) {
                isValid = false;
                $(this).next(".error").text("Please enter a valid email.");
            } else {
                $(this).next(".error").text(""); // Clear previous error messages
            }
        });

             // reCAPTCHA validation
            // const recaptchaResponse = grecaptcha.getResponse();
            // const captchaErrorElement = document.getElementById('captchaerror');
            // if (!recaptchaResponse) {
            // captchaErrorElement.textContent = 'Please complete the reCAPTCHA.';
            // captchaErrorElement.classList.add('cshow');
            // isValid = false; // Set isValid to false if there's a captcha error
            // } else {
            // captchaErrorElement.classList.remove('cshow');
            // }


        // Validate checkboxes
            var checkboxes = fieldset.find("input[type='checkbox']");
            var isChecked = checkboxes.is(':checked');
            
            if (checkboxes.length > 0 && !isChecked) {
                isValid = false;
                $('#cerror').addClass('cshow'); // Show the error message
            } else {
                $('#cerror').removeClass('cshow'); // Hide the error message
            }

            return isValid;
        }

    $(".next").click(function() {
        current_fs = $(this).parent();
        next_fs = $(this).parent().next();

        // Validate current fieldset
        if (validateFieldset(current_fs)) {
            // Prepare data for submission
            var formData = $(this).closest("form").serializeArray();
            formData.push({ name: "step", value: current });

            // Submit via AJAX
            $.ajax({
                type: "POST",
                url: "https://web.membershipanywhere.com/pricesubmit.php",
                data: formData,
                success: function(response) {
                    console.log("Step submitted: " + response);
                    // Check if this is the last step
                    if (current === steps) {
                        $('#pricingsubmit').click();
                        //window.location.href = "thank_you.html"; // Change to your target URL
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Submission failed: " + error);
                }
            });

            // Add Class Active
            $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

            // Show the next fieldset
            next_fs.show();
            // Hide the current fieldset with style
            current_fs.animate({opacity: 0}, {
                step: function(now) {
                    var opacity = 1 - now;
                    current_fs.css({'display': 'none', 'position': 'static'});
                    next_fs.css({'opacity': opacity});
                },
                duration: 500
            });
            setProgressBar(++current);
        }
    });

 $(".previous").click(function() {
        current_fs = $(this).parent();
        previous_fs = $(this).parent().prev();

        // Remove class active
        $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");

        // Show the previous fieldset
        previous_fs.show();

        // Hide the current fieldset with style
        current_fs.animate({ opacity: 0 }, {
            step: function(now) {
                opacity = 1 - now;
                current_fs.css({
                    'display': 'none',
                    'position': 'static'
                });
                previous_fs.css({ 'opacity': opacity });
            },
            duration: 500
        });

        setProgressBar(--current);
    });
    function setProgressBar(curStep) {
        var percent = parseFloat(100 / steps) * curStep;
        percent = percent.toFixed();
        $(".progress-bar").css("width", percent + "%");
    }
});

</script>
<?php get_footer(); ?>