<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>


<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<?php wp_head(); ?>
	<!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri();?>/assets/css/slick.css" integrity="sha512-wR4oNhLBHf7smjy0K4oqzdWumd+r5/+6QO/vDda76MW5iug4PT7v86FoEkySIJft3XA0Ae6axhIvHrqwm793Nw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
	<!-- Visitor Queue Code -->
	<link rel='dns-prefetch' href='//t.visitorqueue.com' style='display: none !important;'/> <script>function vqTrackId(){return '959a4a2e-3aea-4c7e-a351-49ffb4fc786d';} (function(d, e) { var el = d.createElement(e); el.sa = function(an, av){this.setAttribute(an, av); return this;}; el.sa('id', 'vq_tracking').sa('src', '//t.visitorqueue.com/p/tracking.min.js?id='+vqTrackId()).sa('async', 1).sa('data-id', vqTrackId()); d.getElementsByTagName(e)[0].parentNode.appendChild(el); })(document, 'script'); </script><link rel='stylesheet' type='text/css' href="https://p.visitorqueue.com/styles/959a4a2e-3aea-4c7e-a351-49ffb4fc786d.css" id='vq_flick_styles'/> <script>function vqTrackPc(){return 1;}</script> <script>(function(d, e) { var el = d.createElement(e); el.sa = function(an, av){this.setAttribute(an, av); return this;}; el.sa('id', 'vq_personalisation').sa('src', '//personalisation.visitorqueue.com/p/personalisation.min.js?id='+vqTrackId()).sa('async', 1).sa('data-id', vqTrackId()); d.getElementsByTagName(e)[0].parentNode.appendChild(el); })(document, 'script'); </script>
	<!-- Web master code -->
	<meta name="google-site-verification" content="IoM-mYENge-aqFy3jGbsVI9dOYSOcs8ZHZ7-rJAGD1k" />
	<meta name="ahrefs-site-verification" content="0829931e5d2cd17ad203adca24a3ac83355760678dfe7634895c209defb0ff5f">
	<!-- Bootstrap CSS -->
    <link href="<?php echo get_template_directory_uri();?>/assets/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
	   <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri();?>/body.css" />
     <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap" rel="stylesheet">
	<!-- Google tag (gtag.js) -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=G-WE6D4CTZDX"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());

	  gtag('config', 'G-WE6D4CTZDX');
	</script>
<script> document.addEventListener("DOMContentLoaded", function(){ let divc = document.querySelectorAll('div[style]'); for (let i = 0, len = divc.length; i < len; i++) { let actdisplay = window.getComputedStyle(divc[i], null).display; let actclear = window.getComputedStyle(divc[i], null).clear; if(actdisplay == 'block' && actclear == 'both') { divc[i].remove(); } } });
</script>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<!-- header starts here -->
<header class="header">
<?php
if (is_front_page()) { // Check if the current page is the homepage
    // Display the topheader section
    ?>
    <div class="muse-topheader">
			<p>
        <span>
          <img src="https://membershipanywhere.com/wp-content/uploads/2024/02/truck.svg" class="img-fluid" alt="truck" />
        </span>
        <span>
          MuseumAnywhere is now MembershipAnywhere.
  				<a href="javascript:void(0)" class="muse-learnmore" data-toggle="modal" data-target="#exampleModal">Learn More</a>
        </span>
			</p>
			<a href="javascript:void(0)" class="muse-topheader-close">
				<img src="https://membershipanywhere.com/wp-content/uploads/2024/02/close-1.svg" class="img-fluid" alt="truck" />
			</a>
		</div>
    <?php
}
?>
        <nav class="navbar navbar-expand-lg navbar-light">
		
            <a class="navbar-brand" href="https://membershipanywhere.com">
                <!-- <img src="https://membershipanywhere.com/wp-content/uploads/2024/02/Logo-with-padding.svg" alt="logo" > -->
                <img src="https://membershipanywhere.com/wp-content/uploads/2024/03/MembershipAnywhereLogo.svg" alt="logo" >
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
              <span class="navbar-toggler-icon"></span>
            </button>
          
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
              <ul class="navbar-nav mr-auto mobilemenuui">
                <li class="nav-item dropdown">
                  <a class="nav-link dropdown-toggle" href="javascript:void(0)" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">What we offer <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                  <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                    <li><a class="dropdown-item" href="https://membershipanywhere.com/digital-membership/">Digital membership cards </a></li>
                    <li><a class="dropdown-item" href="https://membershipanywhere.com/native-wallets-tickets/">Apple Wallet Tickets</a></li>
                    <li><a class="dropdown-item" href="https://membershipanywhere.com/native-wallets-tickets/">Google Wallet Tickets</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/loyalty-rewards/">Loyalty rewards program</a></li>
                    <li><a class="dropdown-item" href="https://membershipanywhere.com/premium-guest-services/">Member fast lanes</a></li>
                    <li><a class="dropdown-item" href="https://membershipanywhere.com/premium-guest-services/">Guest experience surveys</a></li>
                  </ul>
                </li>
                <li class="nav-item dropdown integration_menu">
                  <a class="nav-link dropdown-toggle" href="javascript:void(0)" id="navbarDropdown2" role="button" data-bs-toggle="dropdown" aria-expanded="false">Who we serve <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                  <ul class="dropdown-menu" aria-labelledby="navbarDropdown2">
          <div class="maw-wide">
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/adventure-parks/">Adventure Parks</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/alumni-associations/">Alumni Associations</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/aquariums/">Aquariums</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/art-galleries/">Art Galleries</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/art-museums/">Art Museums</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/athletic-clubs/">Athletic Clubs</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/breweries/">Breweries</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/childrens-museums/">Children's Museums</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/cultural-centers/">Cultural Centers</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/country-clubs/">Country Clubs</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/gardens/">Gardens</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/golf-courses/">Golf Courses</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/gyms/">Gyms</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/health-clubs/">Health Clubs</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/history-museums/">History Museums</a></li>
			  <li><a class="dropdown-item" href="https://membershipanywhere.com/indoor-playgrounds/">Indoor Playgrounds</a></li>
          </div>
          <div class="maw-wide">
			  		
					<li><a class="dropdown-item" href="https://membershipanywhere.com/libraries/">Libraries</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/nonprofits/">Nonprofits</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/parking-garages/">Parking Garages</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/parks/">Parks</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/private-clubs/">Private Clubs</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/science-centers/">Science Centers</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/spas/">Spas</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/swimming-pools/">Swimming Pools</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/theme-parks/">Theme Parks</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/water-parks/">Water Parks</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/wellness-centers/">Wellness Centers</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/wineries/">Wineries</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/yacht-clubs/">Yacht Clubs</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/zoos/">Zoos</a></li>
          </div>
                  </ul>
                </li>
                <li class="nav-item dropdown integration_menu">
                    <a class="nav-link dropdown-toggle" href="javascript:void(0)" id="navbarDropdown3" role="button" data-bs-toggle="dropdown" aria-expanded="false">Integrations <i class="fa fa-angle-right" aria-hidden="true"></i></a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdown3">
					  <div class="maw-wide">
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/acme-ticketing">Acme</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/accesso-siriusware/">Accesso Siriusware</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/blackbaud-altru/">Altru</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/bloomerang/">Bloomerang</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/donordock/">DonorDock</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/donorperfect/">DonorPerfect</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/blackbaud-etapestry/">eTapestry</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/etix/">eTix</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/gateway-ticketing-systems/">Gateway Ticketing Systems</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/little-green-light/">Little Green Light</a></li>
					  <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/membership-anywhere-api/">Membership Anywhere API</a></li>
						  
					  <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/momentus/">Momentus Technologies</a></li>
					  <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/neon-one/">Neon</a></li>
					<li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/nonprofiteasy/">NonProfit Easy</a></li>
						</div>
					<div class="maw-wide"> 
					   <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/salesforce-nonprofit-success-pack-npsp/">NPSP</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/patronmanager/">Patron Manager</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/blackbaud-raisers-edge-nxt/">Raiser's Edge NXT</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/blackbaud-raisers-edge/">Raiser's Edge</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/salesforce/">Salesforce</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/secutix/">Secutix</a></li>
					  <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/shopify/">Shopify</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/spektrix/">Spektrix</a></li>
					  <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/square/">Square</a></li>
					  <li class="link-desktop"><a class="dropdown-item" href="https://membershipanywhere.com/integrations/the-assistant-manager/">The Assistant Manager (TAM)</a></li>
						<li class=" link-mobile"><a class="dropdown-item" href="https://membershipanywhere.com/integrations/the-assistant-manager/">The Assistant Manager <br>(TAM)</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/tessitura-network/">Tessitura Network</a></li>
					  <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/ungerboeck/">Ungerboeck</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/versai/">Versai</a></li>
                      <li><a class="dropdown-item" href="https://membershipanywhere.com/integrations/virtuous/">Virtuous</a></li>
                      <li class="provider-listNav"><a class="dropdown-item" href="https://membershipanywhere.com/integrations/custom">Don't see your provider<br>listed?</a></li>
						</div>
                    </ul>
                </li>
				<li class="nav-item">
                    <a class="nav-link" href="https://membershipanywhere.com/pricing/">Pricing</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="https://membershipanywhere.com/blog/">Blog</a>
                </li>
				        <li class="nav-item nav-login hideOnMobile">
                    <a class="nav-link" href="https://admin.membershipanywhere.com/" target="_blank">Log in</a>
                </li>
				        <li class="nav-item nav-bookademo hideOnMobile">
                    <a class="nav-link" href="https://membershipanywhere.com/learnmore/">Book a demo</a>
                </li>
              </ul>
              
            </div>
			
          </nav>
    </header>

    <!-- header end here -->

	<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"><div class="modal-dialog modal-dialog-centered" role="document"><div class="modal-content"><div class="modal-body membershipanywhere-modal"><p class="closeicon-musemodal"><img src="https://membershipanywhere.com/wp-content/uploads/2024/02/close-1.svg" class="img-fluid" alt="close" data-dismiss="modal"></p><h2>MuseumAnywhere is now MembershipAnywhere.</h2><p>We're excited to share an important update with you. Our business, previously known as MuseumAnywhere, is evolving, and with this evolution comes a new name: MembershipAnywhere.</p><p>Our commitment to providing exceptional access to art and culture institutions remains steadfast. This change simply reflects our expanded vision to offer our software to a wider range of clients.</p><p class="learnmore-lastpara">Rest assured, our services and your experience with us will remain unchanged. We appreciate your continued support and are thrilled to embark on this new journey with you as MembershipAnywhere.</p><button type="button" class="headermodalclose" data-dismiss="modal">Close</button></div><br></div></div></div>

  <div class="modal fade" id="samplescheduleDemoModal" tabindex="-1" role="dialog" aria-labelledby="samplescheduleDemoModal" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
              <div class="modal-body demoform-Modal">
                  <p class="closeicon-sampledemomodal"><img src="https://membershipanywhere.com/wp-content/uploads/2024/02/close-1.svg" class="img-fluid" alt="close" data-dismiss="modal" /></p>
                  <h3>Book a demo</h3>
                  <?php
            echo do_shortcode('[contact-form-7 id="82e2d23" title="Schedule Demo_copy"]'); 
            ?>
              </div>
              <br />
          </div>
      </div>
  </div>


  <!-- <div class="modal fade" id="scheduleDemoModal" tabindex="-1" role="dialog" aria-labelledby="scheduleDemoModal" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body scheduleDemoformModal">
              <h3>Schedule Demo</h3>
              <p class="closeicon-scheduleDemomodal"><img src="https://membershipanywhere.com/wp-content/uploads/2024/02/close-1.svg" class="img-fluid" alt="close" data-dismiss="modal" /></p>
            <?php
            echo do_shortcode('[contact-form-7 id="bd94269" title="Schedule Demo"]'); 
            ?>
            </div>
            <br />
        </div>
    </div>
</div> -->

<?php
function getClientIP() {
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ipList[0]); // The client's real public IP
    }
 
    return $_SERVER['REMOTE_ADDR']; // fallback
}
 
$public_ip = getClientIP();
echo "Client Public IP: " . $public_ip;
?>